100 REM  JUPITER'S CENTRAL MERIDIAN
105 REM 
110 DT=57: REM  Value of ET-UT (sec)
111 REM    in 1990; change DT for
112 REM    other years as needed!!
115 P1=3.14159265
120 P2=2*P1: RD=180/P1: DR=1/RD
125 GOSUB 330: REM  Get date and UT
130 D=(J-2451545)+F
135 D=D+DT/86400: REM  UT to ET
140 GOSUB 405
145 READ A1,A2,D1,D2
150 T=T-1: REM  Cent from 2000.0
155 A1=A1+A2*T
160 D1=D1+D2*T
165 Q=A1: GOSUB 710: A1=Q*DR
170 Q=D1: GOSUB 710: D1=Q*DR
175 D9=COS(D5)*SIN(A1-A5)
180 N9=SIN(D1)*COS(D5)*COS(A1-A5)
185 N9=N9-COS(D1)*SIN(D5)
190 K=RD*ATN(N9/D9)
195 IF D9<0 THEN K=K+180
200 REM
205 READ W0,W1,W2: REM  System I
210 GOSUB 245
215 PRINT "C-MERID (I):  ";C
220 REM
225 READ W0,W1,W2: REM  System II
230 GOSUB 245
235 PRINT "C-MERID (II): ";C
240 END
245 REM   Rotations from epoch
250 W=W0+W1*(D-.0057755*RR)+W2*T
255 Q=W-K: GOSUB 710: C=Q
260 C=INT(100*C+.5)/100
265 RETURN
275 REM      North Pole R.A.
280 DATA 268.05, +0.107
285 REM      North Pole Dec.
290 DATA 64.49,  -0.015
295 REM      System I
300 DATA 67.10, 877.9000, 1.291
305 REM      System II
310 DATA 43.30, 870.2700, 1.291
315 REM
320 REM    Calendar --> JD
325 REM
330 INPUT "YR,MO,DAY  ";Y,M,D
335 INPUT "UT (H,M,S) ";H1,M1,S1
340 D=D+H1/24+M1/1440+S1/86400
345 G=1: IF Y<1582 THEN G=0
350 D1=INT(D): F=D-D1-.5
355 J=-INT(7*(INT((M+9)/12)+Y)/4)
360 IF G=0 THEN 380
365 S=SGN(M-9): A=ABS(M-9)
370 J3=INT(Y+S*INT(A/7))
375 J3=-INT((INT(J3/100)+1)*3/4)
380 J=J+INT(275*M/9)+D1+G*J3
385 J=J+1721027+2*G+367*Y
390 IF F>=0 THEN 400
395 F=F+1: J=J-1
400 RETURN
405 REM   Fundamental Arguments
410 REM
415 T=D/36525+1
420 REM  T=Centuries from 1900.0
425 L0=.779072+.00273790931*D
430 G0=.993126+.0027377785*D
435 L5=.089608+.00023080893*D
440 G5=.056531+.00023080893*D
445 G6=.882987+.00009294371*D
450 L0=(L0-INT(L0))*P2
455 G0=(G0-INT(G0))*P2
460 L5=(L5-INT(L5))*P2
465 G5=(G5-INT(G5))*P2
470 G6=(G6-INT(G6))*P2
475 REM    Sun
480 L=6910*SIN(G0)
485 L=L+72*SIN(2*G0)
490 L=L-17*T*SIN(G0)
495 L=L-7*COS(G0-G5)
500 R=1.00014-.01675*COS(G0)
505 R=R-.00014*COS(2*G0)
510 L=L0+L/206265
515 REM    Jupiter
520 J=19934*SIN(G5)
525 J=J+5023*T+2511
530 J=J+1093*COS(2*G5-5*G6)
535 J=J+601*SIN(2*G5)
540 J=J-479*SIN(2*G5-5*G6)
545 J=J-185*SIN(2*G5-2*G6)
550 J=J+137*SIN(3*G5-5*G6)
555 J=J-131*SIN(G5-2*G6)
560 B=-4692*COS(G5)
565 B=B+259*SIN(G5)
570 B=B+227-227*COS(2*G5)
575 B=B+30*T*SIN(G5)
580 R5=5.20883-.25122*COS(G5)
585 R5=R5-.00604*COS(2*G5)
590 R5=R5+.0026*COS(2*G5-2*G6)
595 R5=R5-.0017*COS(3*G5-5*G6)
600 R5=R5-.00106*SIN(2*G5-2*G6)
605 R5=R5-.00091*T*SIN(G5)
610 R5=R5-.00084*T*COS(G5)
615 L5=L5+J/206265: B5=B/206265
620 N9=R5*COS(B5)*SIN(L5-L)
625 D9=R5*COS(B5)*COS(L5-L)+R
630 L1=ATN(N9/D9)
635 IF D9<0 THEN L1=L1+P1
640 LL=L1+L
645 V=N9*N9+D9*D9
650 RR=SQR(V+(R5*SIN(B5))^2)
655 S=R5*SIN(B5)/RR
660 BB=ATN(S/SQR(1-S*S))
665 E=(84428-47*T)/206265
670 N9=SIN(LL)*COS(E)-TAN(BB)*SIN(E)
675 D9=COS(LL): A5=ATN(N9/D9)
680 IF D9<0 THEN A5=A5+P1
685 S=SIN(BB)*COS(E)
690 S=S+COS(BB)*SIN(E)*SIN(LL)
695 D5=ATN(S/SQR(1-S*S))
700 RETURN
705 REM
710 REM    Normalize Degrees
715 Q=Q/360: Q=Q-INT(Q): Q=Q*360
720 RETURN
800 REM   This program computes the longtude of Jupiter's central
810 REM   meridian for any date and time.  From SKY & TELESCOPE
820 REM   magazine for December, 1989, page 641.
